#!/bin/sh

# Version 0.1BETA	
# 2010-08-29	Peter.Jonsson@tg.lth.se	
# 2011-01-13	v 0.2	
# 2016-05-24    v 0.3 added g45 support	
# Actions logged here
LOGFILE="/updates/terrameterupdate.log"

# Temporary work place
WORKDIR="/tmp/terrameterupdate"

SOURCE="ui_images.tar"
DIRNAME="ui_images"
BU_DIR="/updates"
FILES_DIR="/updates"

TARGET_DIR="/usr/share/terrameter"
TARGET="$TARGET_DIR/$DIRNAME"


#-------------------------------------------------------------------------------------------
# Changes below this line should be needed only if the commands are in places
#-------------------------------------------------------------------------------------------
_ECHO="/bin/echo"
_DATE="/bin/date"
_RM="/bin/rm"
_MV="/bin/mv"
_TAR="/bin/tar"
#-----------------------------------------------------------------------------------------
#	Logs $1 to a file and optionally to stdout
#-------------------------------------------------------------------------------------------
log()	{


	logitem=$1
	logtime=`$_DATE`
		$_ECHO $logitem	

	$_ECHO -n $logtime >> $LOGFILE
	$_ECHO -n "postproc: "  >> $LOGFILE
	$_ECHO $logitem  >> $LOGFILE
}




#-------------------------------------------------------------------------------------------
# Special processing for update
#-------------------------------------------------------------------------------------------

#log "Preserving old $TARGET"
#$_MV $TARGET $BU_DIR

log "Unpacking new $TARGET_DIR"
$_TAR -x -f $FILES_DIR/$SOURCE -C $TARGET_DIR

#log "Testing..."
#if [ -e $TARGET ]
#then
#	log "Seems to be OK, removing backup"
#	$_RM $BU_DIR/$DIRNAME
#else
#	log "Could not find untarred $TARGET. Rollback."
#	$_MV $BU_DIR/$DIRNAME $TARGET_DIR
#fi

log "Install network support scripts"
touch /var/lib/misc/udhcpd.leases
cp $FILES_DIR/networkmode.sh /etc/init.d/
cp $FILES_DIR/udhcpd.conf /etc/
chmod +x /etc/init.d/networkmode.sh
cp $FILES_DIR/installfiles/terrameter-dhcp /usr/bin/
chmod +x /usr/bin/terrameter-dhcp
echo $1 | grep "terrameter-v2-" 1> /dev/null
if [$? -eq 0]
then
    log "No extra library files to install"
else
    log "Install chart library"
    opkg install $FILES_DIR/installfiles/libwxcode-gtk2u-freechart-2.9-0_svn-r0.5_armv5te.ipk

    log "Install new driver and libboost"
    cp $FILES_DIR/installfiles/libboost_system.so.1.43.0 /usr/lib
    cp $FILES_DIR/installfiles/atmel_spi_slave.ko /lib/modules/2.6.32.6/kernel/drivers/spi
fi

#log "Update .Terrameter file"
sed -i -e "s/UseMarginSetting=0/UseMarginSetting=1/g" -e "s/UsePowerLossSetting=1/UsePowerLossSetting=0/g"  /home/root/.Terrameter

if [ -e $FILES_DIR/installfiles/protocols.tar ]
then
    log "Remove all protocols"
    $_RM -f  /home/root/protocols/*
    log "Install New protocols"
    $_TAR -x -f $FILES_DIR/installfiles/protocols.tar -C /home/root/protocols
fi



log "Post processing done"

