#!/bin/sh
#

# Actions logged here
LOGFILE="/updates/terrameterupdate.log"

LSSERIAL=""
UPDATEPATH='/updates'
VPNFILETAR='/updates/vpnconf.tar'
VPNDEST='/etc/openvpn/'

#-------------------------------------------------------------------------------------------
# Changes below this line should be needed only if the commands are in places
#-------------------------------------------------------------------------------------------
_ECHO="/bin/echo"
_DATE="/bin/date"
_RM="/bin/rm"
_MV="/bin/mv"
_MKDIR="/bin/mkdir"
_CHMOD="/bin/chmod"
_GREP="/bin/grep"
#0.2
_SHELL="/bin/bash"
_CAT="/bin/cat"
_TAR="/bin/tar"
#

#-------------------------------------------------------------------------------------------
#	Logs $1 to a file and optionally to stdout
#-------------------------------------------------------------------------------------------
log()	{


	logitem=$1
	logtime=`$_DATE`
		$_ECHO $logitem	

	$_ECHO -n $logtime >> $LOGFILE
	$_ECHO -n ": "  >> $LOGFILE
	$_ECHO $logitem  >> $LOGFILE
}

#-------------------------------------------------------------------------------------------
# VPN update certificate
#-------------------------------------------------------------------------------------------
#

if [ $# -ne 1 ]
then
    echo "Must provide basename for upgrade"
    log "Must provide basename for upgrade"
    exit
fi	

BASENAME=$1

LSSERIAL=$($_GREP "LS2" /etc/hostname)

_RESULT=$($_TAR -tf $VPNFILETAR | $_GREP $LSSERIAL)

if [ -z $_RESULT ]
then {
	log "WARNING!!!!!!"
	log "VPN cert not in file"
	log "If no TUN then contact support"
	}
else {
	killall openvpn
	$_TAR -xf $VPNFILETAR $_RESULT -C $VPNDEST
	/usr/sbin/openvpn --daemon --writepid /var/run/openvpn.$LSSERIAL.pid --config $VPNDEST/$_RESULT --cd $VPNDEST
	log "VPN updated"
	}
fi
$_RM $VPNFILETAR
BASENAME="$BASENAME.tar"
$_RM $UPDATEPATH/$BASENAME
log "Install file removed"

reboot
