#!/bin/sh

# Version 0.1
# 2010-08-29	Peter.Jonsson@tg.lth.se
# 2011-01-13	v 0.2
# 2011-10-21	Remade for Linux updating based on v 0.2 of terrameter updating
# 2016-01-28	Remade for enabling updating of TX software

# This is where the txusbbootmode program lives in the LS

TARGET="/home/root"
PRODUCT="settings"
PRODUCTNAME="Settingsfiles"

# Name and filename of executable (no path, just the filename)
EXECUTABLE=""
EXECUTABLEFILEMODE="755"
DELETEABLEFILEMODE="777"

# Archive directory
ARCDIR="/updates"

# Log and backup directory
LOGDIR="$ARCDIR/$PRODUCT"

# Where the temporary backup is stored
TARGETBACKUP="$LOGDIR/old_$BASENAME"

# Actions logged here
LOGFILE="$LOGDIR/$PRODUCT.log"

# Temporary work place
WORKDIR="/home/root/settings"

# After work script
POST=""

#------------------------------------------------------------------------------------
# Changes below this line should be needed only if the commands are in places
#------------------------------------------------------------------------------------
_ECHO="/bin/echo"
_DATE="/bin/date"
_RM="/bin/rm"
_MV="/bin/mv"
_MKDIR="/bin/mkdir"
_CHMOD="/bin/chmod"
_SLEEP="/bin/sleep"
_PS="/bin/ps"
_GREP="/bin/grep"
_UNZIP="unzip"
_KILLALL="/usr/bin/killall"

_SHELL="/bin/bash"

_CP="/bin/cp"
_CMP="cmp"
_FLASH_ERASE="flash_eraseall"
_REBOOT="reboot"
_MD5SUM="md5sum"
_POWER_TEST="/$ARCDIR/mcp3204_test"
_STOPCOMMAND="/etc/init.d/gpe-dm stop"
_STARTCOMMAND="/etc/init.d/gpe-dm start"
_DMESG="/bin/dmesg"

#------------------------------------------------------------------------------------
# Changes below this line should be needed only if/when bugs are found or the
# functionality shall be changed
#------------------------------------------------------------------------------------

status_return()	{

	if [ $1 -eq 0 ]
	then
		status="0"
	else
		status="1"
	fi
}

#------------------------------------------------------------------------------------
#	Logs $1 to a file and to stdout
#------------------------------------------------------------------------------------
log()	{

	logitem="// $1"
	logtime=`$_DATE`
  
	$_ECHO $logitem

	$_ECHO -n $logtime >> $LOGFILE
	$_ECHO -n ": "  >> $LOGFILE
	$_ECHO $logitem  >> $LOGFILE
}

#------------------------------------------------------------------------------------
#	Logs a newline to a file and to stdout
#------------------------------------------------------------------------------------
logNL()	{

	logitem=""
  
	$_ECHO $logitem

	$_ECHO $logitem  >> $LOGFILE
}

#------------------------------------------------------------------------------------
#		Stub for integrity check
#------------------------------------------------------------------------------------
test_integrity_of_archive()	{

	#$_UNZIP -t $PROGRAMGZ 1> /tmp/tmp.tmp 2> /dev/null
	$_UNZIP -t $PROGRAMGZ

  if [ $? -eq 0 ]
	then
		log "Archive checks out OK"
		status_return 0
	else
		log "There seems to be something wrong with the archive"
		status_return 1
	fi
}

#------------------------------------------------------------------------------------
#	Tests if the archive is OK and if the update file is there
#------------------------------------------------------------------------------------

test_and_unpack_archive()	{

  logNL
	log "Begin testing and unpacking of archive $PROGRAMGZ"

	# First of all, see if the update is there at all
	if [ -e $PROGRAMGZ ]
	then
		log "Archive exists"

			log "Archive is OK"

			# Uncompress to the working directory

			if [ ! -d $WORKDIR ]
			then
				$_MKDIR -p $WORKDIR
			fi

			$_UNZIP -o -q  $PROGRAMGZ -d $WORKDIR
			#$_UNZIP -n -q  $PROGRAMGZ -d $WORKDIR
			if [ $? -eq 0 ]
			then
				log "Installation OK"
				status_return 0
			else
				log "There seems to be something wrong with the Installation"
			status_return 1
	fi
	else
		log "The zip archive $PROGRAMGZ could not be found"
		status_return 1
	fi
}

#------------------------------------------------------------------------------------
# Copies the new enabler into place and runs it.
#------------------------------------------------------------------------------------

#------------------------------------------------------------------------------------
# Run the post-install script	(0.2)
#------------------------------------------------------------------------------------

post_install()	{

  logNL
	log "Begin post installation activities"

	if [ -e $POST ]
	then
    log "Try file $POST"
    chmod +x $POST
    chown root $POST
    $POST
    log "$POST has been run"

	else
		log "No $POST file"
		status_return 1
	fi
}

#------------------------------------------------------------------------------------
# Test the executable
#------------------------------------------------------------------------------------

test_executable()	{

	$_CMP $WORKDIR/$BASENAME$EXECUTABLE $TARGET/$BASENAME$EXECUTABLE
	if [ $? -eq 0 ]
	then
		status_return 0
	else
		status_return 1
	fi
}

#------------------------------------------------------------------------------------
# Cleanup leftovers
#------------------------------------------------------------------------------------

cleanup_after_success()	{

	if [ -e $PROGRAMGZ ]
	then
		log "Remove update archive"
		$_CHMOD $DELETEABLEFILEMODE $PROGRAMGZ
		$_RM -rf $PROGRAMGZ
	fi

	if [ -e $CONTAINER ]
	then
		log "Remove uploaded .tar from Terrameter "
		$_CHMOD $DELETEABLEFILEMODE $CONTAINER
		$_RM $CONTAINER
	fi

# Incorrect $SELF variable
#	if [ -e $SELF ]
#	then
#		log "Remove update script "
#		$_CHMOD $DELETEABLEFILEMODE $SELF
#		$_RM $SELF
#	fi
}

#------------------------------------------------------------------------------------
# Cleanup leftovers, but leave roll back script and backup behind
#------------------------------------------------------------------------------------

cleanup_after_failure()	{

	if [ -e $PROGRAMGZ ]
	then
		log "Remove update archive"
		$_CHMOD $DELETEABLEFILEMODE $PROGRAMGZ
		$_RM $PROGRAMGZ
	fi
}

#------------------------------------------------------------------------------------
# MAIN
#------------------------------------------------------------------------------------

if [ $# -ne 1 ]
then
	echo "Must provide basename for upgrade"
	exit
fi

BASENAME=$1
$_MKDIR -p $LOGDIR
logNL
log "Script start: $BASENAME"

# Container name (the one uploaded from the PC)
CONTAINER="$ARCDIR/$BASENAME.tar"

# This is the name of the update
PROGRAMGZ="$ARCDIR/$BASENAME.zip"

# This is the name of this script
# ???? This is incorrect ?????
#SELF="$ARCDIR/$BASENAME.sh"



# So, lets start working
test_and_unpack_archive


  if [ $status = "0" ] 
  then
    logNL
    log "Operation performed"

# this is untested
    cleanup_after_success
  else
    log "Could not perform operation"
    
# this is untested
    cleanup_after_failure
  fi

